/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.typebinding;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.core.typebinding.IBinding;
import com.aptana.editor.php.core.typebinding.IBindingReporter;
import com.aptana.editor.php.core.typebinding.ITypeBinding;
import com.aptana.editor.php.core.typebinding.TypeBinding;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.core.typebinding.MethodBinding;
import com.aptana.editor.php.internal.core.typebinding.ModuleBinding;
import com.aptana.editor.php.internal.indexer.CallPath;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.FunctionPathReference;
import com.aptana.editor.php.internal.indexer.PHPDocUtils;
import com.aptana.editor.php.internal.indexer.PHPTypeProcessor;
import com.aptana.editor.php.internal.indexer.StaticPathReference;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import com.aptana.editor.php.internal.indexer.VariablePathReference;
import com.aptana.editor.php.internal.model.impl.SourceModule;
import com.aptana.editor.php.internal.parser.phpdoc.FunctionDocumentation;
import com.aptana.editor.php.internal.parser.phpdoc.TypedDescription;
import com.aptana.editor.php.internal.search.PHPSearchEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;
import org2.eclipse.php.core.compiler.PHPFlags;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.Assignment;
import org2.eclipse.php.internal.core.ast.nodes.Block;
import org2.eclipse.php.internal.core.ast.nodes.CatchClause;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org2.eclipse.php.internal.core.ast.nodes.ClassName;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Dispatch;
import org2.eclipse.php.internal.core.ast.nodes.DoStatement;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org2.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org2.eclipse.php.internal.core.ast.nodes.ForStatement;
import org2.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org2.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org2.eclipse.php.internal.core.ast.nodes.FunctionName;
import org2.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.IfStatement;
import org2.eclipse.php.internal.core.ast.nodes.Include;
import org2.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org2.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org2.eclipse.php.internal.core.ast.nodes.Scalar;
import org2.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org2.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org2.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org2.eclipse.php.internal.core.ast.nodes.TryStatement;
import org2.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Variable;
import org2.eclipse.php.internal.core.ast.nodes.VariableBase;
import org2.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org2.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDoc;

public class TypeBindingBuilder {
    private static final String THIS = "this";
    private static final String SELF = "self";
    private static final String DEFINE = "define";
    private Map<Set<Object>, Set<String>> resolvedTypes = new HashMap<Set<Object>, Set<String>>();
    private boolean globalMode = true;
    private int currentOffset = 0;
    private List<Comment> comments;
    private String source;
    private Set<String> overallGlobalImports = new HashSet<String>();
    private boolean isReportedStackGlobal = true;

    public static void buildBindings(Program program) {
        TypeBindingBuilder.buildBindings(program, null);
    }

    public static void buildBindings(Program program, String source) {
        if (program != null) {
            new TypeBindingBuilder().indexModule(program, source, new IBindingReporter(){

                public void report(ASTNode node, IBinding binding) {
                    node.setBinding(binding);
                }
            });
            program.setBindingCompleted(true);
        } else {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error building the PHP bindings for the AST", (Throwable)new IllegalArgumentException("Cannot build the PHP bindings with a null AST"));
        }
    }

    public TypeBindingBuilder() {
    }

    public TypeBindingBuilder(boolean globalMode, int currentOffset) {
        this.globalMode = globalMode;
        this.currentOffset = currentOffset;
    }

    public synchronized void indexModule(Program program, String source, IBindingReporter reporter) {
        try {
            this.comments = program.comments();
            this.source = source;
            PHPASTVisitor visitor = new PHPASTVisitor(reporter, program);
            program.accept((Visitor)visitor);
        }
        catch (Throwable th) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)("Unexpected exception while indexing module " + program.toString()), (Throwable)th);
        }
    }

    public Set<String> getGlobalImports() {
        return this.overallGlobalImports;
    }

    public boolean isReportedScopeGlobal() {
        return this.isReportedStackGlobal;
    }

    public boolean isReportedScopeUnderClassOrFunction() {
        return this.isReportedStackGlobal;
    }

    private static String typeToString(int intType) {
        switch (intType) {
            case 0: {
                return "_integer";
            }
            case 1: {
                return "_real";
            }
            case 2: {
                return "_string";
            }
            case 4: {
                return "_system";
            }
            case 3: {
                return "_unknown";
            }
        }
        return null;
    }

    private Comment findFunctionPHPDocComment(int offset) {
        return this.findComment(offset, 2);
    }

    private Comment findComment(int offset, int type) {
        if (this.comments == null || this.comments.isEmpty()) {
            return null;
        }
        Comment nearestComment = null;
        for (Comment comment : this.comments) {
            if (comment.getStart() > offset) break;
            nearestComment = comment;
        }
        if (nearestComment == null) {
            return null;
        }
        if (nearestComment.getCommentType() != type) {
            return null;
        }
        if (this.source != null) {
            int i = nearestComment.getEnd() + 1;
            while (i < offset - 1) {
                char ch = this.source.charAt(i);
                if (!Character.isWhitespace(ch)) {
                    return null;
                }
                ++i;
            }
            return nearestComment;
        }
        return null;
    }

    private static class ClassScopeInfo {
        private Map<String, IElementEntry> fields = new HashMap<String, IElementEntry>();
        private String name;

        private ClassScopeInfo() {
        }

        private ClassScopeInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Collection<IElementEntry> getFields() {
            return this.fields.values();
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public IElementEntry getField(String fieldName) {
            return this.fields.get(fieldName);
        }

        public void setField(String fieldName, IElementEntry field) {
            this.fields.put(fieldName, field);
        }

        public boolean addFieldTypes(String fieldName, Set<Object> types) {
            IElementEntry fieldEntry = this.fields.get(fieldName);
            if (fieldEntry == null) {
                return false;
            }
            Object entryValue = fieldEntry.getValue();
            if (!(entryValue instanceof VariablePHPEntryValue)) {
                return false;
            }
            VariablePHPEntryValue value = (VariablePHPEntryValue)entryValue;
            for (Object type : types) {
                value.addType(type);
            }
            return true;
        }
    }

    private class PHPASTVisitor
    extends AbstractVisitor {
        private IBindingReporter reporter;
        private Map<String, ITypeBinding> binding = new HashMap<String, ITypeBinding>();
        private ISourceModule module;
        private ClassScopeInfo currentClass;
        private IElementEntry currentFunction;
        private Stack<Scope> scopes = new Stack();
        private String currentNamespace = "";
        boolean localStackReported = false;
        private Map<String, Set<Object>> localParametersMap;

        private PHPASTVisitor(IBindingReporter reporter2, Program program) {
            this.reporter = reporter2;
            this.module = program.getSourceModule();
        }

        public boolean visit(ClassDeclaration classDeclaration) {
            List interfaces = classDeclaration.interfaces();
            ArrayList<String> interfaceNames = new ArrayList<String>(interfaces.size());
            int i = 0;
            while (i < interfaces.size()) {
                interfaceNames.add(((Identifier)interfaces.get(i)).getName());
                Identifier identifier = (Identifier)interfaces.get(i);
                identifier.setBinding(this.resolveTypeBinding(((Identifier)interfaces.get(i)).getName()));
                ++i;
            }
            Expression superClassIdentifier = classDeclaration.getSuperClass();
            String superClassName = null;
            if (superClassIdentifier != null && (superClassIdentifier.getType() == 65 || superClassIdentifier.getType() == 33)) {
                superClassName = ((Identifier)superClassIdentifier).getName();
                superClassIdentifier.setBinding(this.resolveTypeBinding(superClassName));
            }
            classDeclaration.setBinding(this.resolveTypeBinding(classDeclaration.getName().getName()));
            ClassPHPEntryValue value = new ClassPHPEntryValue(classDeclaration.getModifier(), superClassName, interfaceNames, this.currentNamespace);
            value.setStartOffset(classDeclaration.getStart());
            value.setEndOffset(classDeclaration.getEnd());
            this.currentClass = new ClassScopeInfo(classDeclaration.getName().getName());
            return true;
        }

        private IBinding resolveTypeBinding(String superClassName) {
            IType[] convertClasses = PHPSearchEngine.getInstance().findTypes(superClassName, null);
            if (convertClasses != null && convertClasses.length > 0) {
                return new TypeBinding(convertClasses[0]);
            }
            return null;
        }

        public boolean visit(InterfaceDeclaration interfaceDeclaration) {
            List interfaces = interfaceDeclaration.interfaces();
            ArrayList<String> interfaceNames = new ArrayList<String>(interfaces.size());
            for (Identifier interfaceName : interfaces) {
                interfaceNames.add(interfaceName.getName());
            }
            ClassPHPEntryValue value = new ClassPHPEntryValue(8, null, interfaceNames, this.currentNamespace);
            value.setStartOffset(interfaceDeclaration.getStart());
            value.setEndOffset(interfaceDeclaration.getEnd());
            return true;
        }

        public boolean visit(StaticConstantAccess classConstantAccess) {
            this.visitStaticDispatch((StaticDispatch)classConstantAccess);
            return super.visit(classConstantAccess);
        }

        private void visitStaticDispatch(StaticDispatch classConstantAccess) {
            Expression className = classConstantAccess.getClassName();
            if (className != null && (className.getType() == 65 || className.getType() == 33)) {
                IBinding resolveTypeBinding = this.resolveTypeBinding(((Identifier)className).getName());
                this.reporter.report((ASTNode)classConstantAccess, resolveTypeBinding);
                this.reporter.report((ASTNode)classConstantAccess.getClassName(), resolveTypeBinding);
            }
        }

        public boolean visit(StaticMethodInvocation staticMethodInvocation) {
            this.visitStaticDispatch((StaticDispatch)staticMethodInvocation);
            return super.visit(staticMethodInvocation);
        }

        public boolean visit(FunctionInvocation functionInvocation) {
            Set<Object> defineTypes;
            List parameters;
            FunctionName funcName = functionInvocation.getFunctionName();
            if (funcName == null) {
                return true;
            }
            Expression functionName = funcName.getName();
            if (functionName != null) {
                Variable vr;
                Expression name;
                if (functionName.getType() == 33 && !TypeBindingBuilder.DEFINE.equals(((Identifier)functionName).getName())) {
                    return true;
                }
                if (functionName.getType() == 60 && (name = (vr = (Variable)functionName).getName()) != null && name.getType() == 33 && !TypeBindingBuilder.DEFINE.equals(((Identifier)name).getName())) {
                    return true;
                }
            }
            if ((parameters = functionInvocation.parameters()).size() < 2) {
                return true;
            }
            if (((Expression)parameters.get(0)).getType() != 51) {
                return true;
            }
            if (2 != ((Scalar)parameters.get(0)).getScalarType()) {
                return true;
            }
            String defineName = ((Scalar)parameters.get(0)).getStringValue();
            if (defineName.startsWith("\"")) {
                defineName = defineName.substring(1);
            }
            if (defineName.endsWith("\"")) {
                defineName = defineName.substring(0, defineName.length() - 1);
            }
            if (defineName.startsWith("'")) {
                defineName = defineName.substring(1);
            }
            if (defineName.endsWith("'")) {
                defineName = defineName.substring(0, defineName.length() - 1);
            }
            if ((defineTypes = this.countExpressionTypes((Expression)parameters.get(1))) == null) {
                return true;
            }
            VariableInfo info = new VariableInfo(defineName, defineTypes, this.getCurrentScope(), functionInvocation.getStart(), 128);
            this.getCurrentScope().addVariable(info);
            return true;
        }

        public boolean visit(FunctionDeclaration functionDeclaration) {
            if (functionDeclaration.getParent() != null && functionDeclaration.getParent() instanceof MethodDeclaration) {
                return true;
            }
            Comment comment = TypeBindingBuilder.this.findFunctionPHPDocComment(functionDeclaration.getStart());
            Identifier functionNameIdentifier = functionDeclaration.getFunctionName();
            if (functionNameIdentifier == null) {
                return true;
            }
            List parameters = functionDeclaration.formalParameters();
            int[] parameterPositions = parameters == null || parameters.size() == 0 ? null : new int[parameters.size()];
            this.localParametersMap = null;
            if (parameters != null && parameters.size() > 0) {
                this.localParametersMap = new LinkedHashMap<String, Set<Object>>(parameters.size());
            }
            ArrayList<Boolean> mandatoryParams = new ArrayList<Boolean>();
            if (parameters != null) {
                int parCount = 0;
                for (FormalParameter parameter : parameters) {
                    Identifier nameIdentifier = parameter.getParameterNameIdentifier();
                    if (nameIdentifier == null) continue;
                    String parameterName = nameIdentifier.getName();
                    parameterPositions[parCount] = parameter.getStart();
                    String parameterType = null;
                    Expression parameterTypeIdentifier = parameter.getParameterType();
                    if (parameterTypeIdentifier != null && (parameterTypeIdentifier.getType() == 65 || parameterTypeIdentifier.getType() == 33)) {
                        parameterType = ((Identifier)parameterTypeIdentifier).getName();
                    }
                    HashSet<String> types = null;
                    if (parameterType != null) {
                        types = new HashSet<String>(1);
                        types.add(parameterType);
                    }
                    this.localParametersMap.put(parameterName, types);
                    mandatoryParams.add(parameter.getDefaultValue() == null || parameter.isMandatory());
                    ++parCount;
                }
            }
            String[] returnTypes = null;
            if (comment != null) {
                returnTypes = this.applyFunctionComment(comment, this.localParametersMap);
            }
            boolean[] mandatories = new boolean[mandatoryParams.size()];
            int j = 0;
            while (j < mandatoryParams.size()) {
                mandatories[j] = (Boolean)mandatoryParams.get(j);
                ++j;
            }
            FunctionPHPEntryValue entryValue = new FunctionPHPEntryValue(0, false, this.localParametersMap, parameterPositions, mandatories, functionDeclaration.getStart(), this.currentNamespace);
            if (returnTypes != null) {
                HashSet<Object> returnTypesSet = new HashSet<Object>();
                String[] stringArray = returnTypes;
                int n = returnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String returnType = stringArray[n2];
                    returnTypesSet.add(returnType);
                    ++n2;
                }
                entryValue.setReturnTypes(returnTypesSet);
            }
            return true;
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            int modifier;
            Comment comment = TypeBindingBuilder.this.findFunctionPHPDocComment(methodDeclaration.getStart());
            FunctionDeclaration functionDeclaration = methodDeclaration.getFunction();
            if (functionDeclaration == null) {
                return true;
            }
            Identifier functionNameIdentifier = functionDeclaration.getFunctionName();
            if (functionNameIdentifier == null) {
                return true;
            }
            List parameters = functionDeclaration.formalParameters();
            int[] parameterPositions = parameters == null || parameters.size() == 0 ? null : new int[parameters.size()];
            LinkedHashMap<String, Set<Object>> parametersMap = null;
            if (parameters.size() > 0) {
                parametersMap = new LinkedHashMap<String, Set<Object>>(parameters.size());
            }
            ArrayList<Boolean> mandatoryParams = new ArrayList<Boolean>();
            if (parameters != null) {
                int parCount = 0;
                for (FormalParameter parameter : parameters) {
                    Identifier nameIdentifier = parameter.getParameterNameIdentifier();
                    if (nameIdentifier == null) continue;
                    String parameterName = nameIdentifier.getName();
                    parameterPositions[parCount] = parameter.getStart();
                    String parameterType = null;
                    Expression parameterTypeIdentifier = parameter.getParameterType();
                    if (parameterTypeIdentifier != null && (parameterTypeIdentifier.getType() == 65 || parameterTypeIdentifier.getType() == 33)) {
                        parameterType = ((Identifier)parameterTypeIdentifier).getName();
                    }
                    HashSet<String> types = null;
                    if (parameterType != null) {
                        types = new HashSet<String>(1);
                        types.add(parameterType);
                    }
                    parametersMap.put(parameterName, types);
                    mandatoryParams.add(parameter.getDefaultValue() == null || parameter.isMandatory());
                    ++parCount;
                }
            }
            String[] returnTypes = null;
            if (comment != null) {
                returnTypes = this.applyFunctionComment(comment, parametersMap);
            }
            if (!(PHPFlags.isPublic((int)(modifier = methodDeclaration.getModifier())) || PHPFlags.isProtected((int)modifier) || PHPFlags.isPrivate((int)modifier))) {
                modifier |= 0x40;
            }
            boolean[] mandatories = new boolean[mandatoryParams.size()];
            int j = 0;
            while (j < mandatoryParams.size()) {
                mandatories[j] = (Boolean)mandatoryParams.get(j);
                ++j;
            }
            FunctionPHPEntryValue entryValue = new FunctionPHPEntryValue(modifier, true, parametersMap, parameterPositions, mandatories, methodDeclaration.getStart(), this.currentNamespace);
            if (returnTypes != null) {
                HashSet<Object> returnTypesSet = new HashSet<Object>();
                String[] stringArray = returnTypes;
                int n = returnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String returnType = stringArray[n2];
                    returnTypesSet.add(returnType);
                    ++n2;
                }
                entryValue.setReturnTypes(returnTypesSet);
            }
            this.reporter.report((ASTNode)methodDeclaration, (IBinding)new MethodBinding(this.currentClass != null ? this.currentClass.getName() : "", methodDeclaration.getFunction().getFunctionName().getName(), modifier, this.module));
            return true;
        }

        public boolean visit(Variable variable) {
            ASTNode parent = variable.getParent();
            if (parent instanceof Assignment) {
                Assignment assignment = (Assignment)parent;
                if (variable.equals(assignment.getLeftHandSide())) {
                    boolean staticDeclaration = parent.getParent() instanceof StaticStatement;
                    return this.handleAssigment(variable, assignment, staticDeclaration);
                }
            } else if (parent instanceof ExpressionStatement) {
                String variableName = this.getVariableName((Expression)variable);
                if (variableName == null || !variable.isDollared()) {
                    return true;
                }
                VariableInfo variableInfo = new VariableInfo(variableName, null, this.getCurrentScope(), variable.getStart());
                this.getCurrentScope().addVariable(variableInfo);
            } else if (parent instanceof InfixExpression) {
                String variableName = this.getVariableName((Expression)variable);
                if (variableName == null) {
                    return true;
                }
                InfixExpression expr = (InfixExpression)parent;
                Set<Object> types = this.countInfixExpressionTypes(expr);
                VariableInfo variableInfo = new VariableInfo(variableName, types, this.getCurrentScope(), variable.getStart());
                this.getCurrentScope().addVariable(variableInfo);
            }
            return true;
        }

        public boolean visit(StaticFieldAccess fieldAccess) {
            this.visitStaticDispatch((StaticDispatch)fieldAccess);
            if (this.currentClass == null) {
                return true;
            }
            if (fieldAccess.getParent() == null || !(fieldAccess.getParent() instanceof Assignment)) {
                return true;
            }
            Expression className = fieldAccess.getClassName();
            if (className == null || className.getType() != 33 && className.getType() != 65 || !TypeBindingBuilder.SELF.equals(((Identifier)className).getName())) {
                return true;
            }
            String fieldName = this.getVariableName((Expression)fieldAccess.getField());
            if (fieldName == null) {
                return true;
            }
            Expression value = ((Assignment)fieldAccess.getParent()).getRightHandSide();
            Set<Object> valueTypes = this.countExpressionTypes(value);
            if (valueTypes != null && valueTypes.size() > 0) {
                if (this.currentClass.hasField(fieldName)) {
                    this.currentClass.addFieldTypes(fieldName, valueTypes);
                } else {
                    this.reportField(192, fieldName, valueTypes, fieldAccess.getStart());
                }
            }
            return true;
        }

        public boolean visit(ConstantDeclaration constantDeclaration) {
            if (this.currentClass == null) {
                return true;
            }
            List variableNames = constantDeclaration.names();
            List values = constantDeclaration.initializers();
            int i = 0;
            while (i < variableNames.size()) {
                String variableName = ((Identifier)variableNames.get(i)).getName();
                Expression value = (Expression)values.get(i);
                Set<Object> valueTypes = this.countExpressionTypes(value);
                if (valueTypes != null && valueTypes.size() > 0) {
                    if (this.currentClass.hasField(variableName)) {
                        this.currentClass.addFieldTypes(variableName, valueTypes);
                    } else {
                        this.reportField(196, variableName, valueTypes, constantDeclaration.getStart());
                    }
                }
                ++i;
            }
            return true;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            if (methodInvocation == null) {
                return true;
            }
            VariableBase leftSide = methodInvocation.getDispatcher();
            if (!(leftSide instanceof Variable)) {
                return true;
            }
            FunctionInvocation rightSide = methodInvocation.getMember();
            if (rightSide != null) {
                ITypeBinding bnd = this.resolveVariableTypeBinding(this.getVariableName((Expression)((Variable)leftSide)));
                this.reporter.report((ASTNode)leftSide, (IBinding)bnd);
                return true;
            }
            return true;
        }

        public boolean visit(FieldAccess fieldAccess) {
            if (fieldAccess == null) {
                return false;
            }
            VariableBase rightSide = fieldAccess.getMember();
            if (!(rightSide instanceof Variable)) {
                return true;
            }
            VariableBase leftSide = fieldAccess.getDispatcher();
            if (!(leftSide instanceof Variable)) {
                return true;
            }
            String fieldName = this.getVariableName((Expression)((Variable)rightSide));
            if (fieldName != null) {
                ITypeBinding bnd = this.resolveVariableTypeBinding(this.getVariableName((Expression)((Variable)leftSide)));
                this.reporter.report((ASTNode)leftSide, (IBinding)bnd);
                return true;
            }
            if (this.currentClass == null) {
                return true;
            }
            if (fieldAccess.getParent() == null || !(fieldAccess.getParent() instanceof Assignment)) {
                return true;
            }
            if (fieldAccess != ((Assignment)fieldAccess.getParent()).getLeftHandSide()) {
                return true;
            }
            String variableName = this.getVariableName((Expression)((Variable)leftSide));
            if (variableName == null || !TypeBindingBuilder.THIS.equals(variableName)) {
                return true;
            }
            Expression value = ((Assignment)fieldAccess.getParent()).getRightHandSide();
            Set<Object> valueTypes = this.countExpressionTypes(value);
            if (valueTypes != null && valueTypes.size() > 0) {
                if (this.currentClass.hasField(fieldName)) {
                    this.currentClass.addFieldTypes(fieldName, valueTypes);
                } else {
                    this.reportField(64, fieldName, valueTypes, fieldAccess.getStart());
                }
            }
            return true;
        }

        private ITypeBinding resolveVariableTypeBinding(String fieldName) {
            Scope currentScope = this.getCurrentScope();
            VariableInfo variable = currentScope.getVariable(fieldName);
            if (variable != null) {
                Set<Object> variableTypes = variable.getVariableTypes();
                Set<String> ts = null;
                Set<String> set = (Set<String>)TypeBindingBuilder.this.resolvedTypes.get(variableTypes);
                if (set != null) {
                    ts = set;
                } else {
                    ts = PHPTypeProcessor.processTypes(variableTypes, PHPGlobalIndexer.getInstance().getIndex());
                    TypeBindingBuilder.this.resolvedTypes.put(variableTypes, ts);
                }
                if (ts.size() == 1) {
                    String tn = ts.iterator().next();
                    if (!this.binding.containsKey(tn)) {
                        ITypeBinding typeBinding = (ITypeBinding)this.resolveTypeBinding(tn);
                        this.binding.put(tn, typeBinding);
                        return typeBinding;
                    }
                    ITypeBinding typeBinding = this.binding.get(tn);
                    return typeBinding;
                }
            }
            return null;
        }

        public boolean visit(FieldsDeclaration fieldsDeclaration) {
            Variable[] variables = fieldsDeclaration.getVariableNames();
            Expression[] initialValues = fieldsDeclaration.getInitialValues();
            int modifier = fieldsDeclaration.getModifier();
            if (!(PHPFlags.isPublic((int)modifier) || PHPFlags.isProtected((int)modifier) || PHPFlags.isPrivate((int)modifier))) {
                modifier |= 0x40;
            }
            int i = 0;
            while (i < variables.length) {
                Variable fieldVariable = variables[i];
                Expression initialValue = initialValues[i];
                String fieldName = this.getVariableName((Expression)fieldVariable);
                if (fieldName != null) {
                    Set<Object> fieldTypes = null;
                    if (initialValue != null) {
                        fieldTypes = this.countExpressionTypes(initialValue);
                    }
                    this.reportField(modifier, fieldName, fieldTypes, fieldVariable.getStart());
                }
                ++i;
            }
            return true;
        }

        public boolean visit(GlobalStatement globalStatement) {
            List variables = globalStatement.variables();
            HashSet<String> imports = new HashSet<String>();
            for (Variable variable : variables) {
                String varName = this.getVariableName((Expression)variable);
                if (varName == null) continue;
                imports.add(varName);
                this.getGlobalScope().addVariable(new VariableInfo(varName, null, this.getGlobalScope(), globalStatement.getStart()));
            }
            this.getCurrentScope().addGlobalImports(imports);
            return true;
        }

        public boolean visit(ReturnStatement returnStatement) {
            if (this.currentFunction == null) {
                return true;
            }
            Expression expression = returnStatement.getExpression();
            Set<Object> types = this.countExpressionTypes(expression);
            if (!(this.currentFunction.getValue() instanceof FunctionPHPEntryValue)) {
                return true;
            }
            FunctionPHPEntryValue value = (FunctionPHPEntryValue)this.currentFunction.getValue();
            if (types != null) {
                Set<Object> currentTypes = value.getReturnTypes();
                if (currentTypes == null || currentTypes.size() == 0) {
                    currentTypes = new HashSet<Object>();
                }
                currentTypes.addAll(types);
                value.setReturnTypes(currentTypes);
            }
            return true;
        }

        public void endVisit(ClassDeclaration classDeclaration) {
            this.currentClass = null;
        }

        public void endVisit(FunctionDeclaration functionDeclaration) {
            this.currentFunction = null;
            this.localParametersMap = null;
        }

        public void endVisit(MethodDeclaration methodDeclaration) {
            this.currentFunction = null;
            this.localParametersMap = null;
        }

        public void endVisit(Program program) {
            this.endVisitScopeNode((ASTNode)program);
        }

        public boolean visit(Program program) {
            this.startVisitScopeNode((ASTNode)program);
            return true;
        }

        public boolean visit(Block block) {
            this.startVisitScopeNode(block.getParent());
            this.addBlockVariables(block);
            return true;
        }

        public boolean visit(CatchClause catchClause) {
            return true;
        }

        public boolean visit(DoStatement doStatement) {
            return true;
        }

        public boolean visit(ForEachStatement forEachStatement) {
            return true;
        }

        public boolean visit(ForStatement forStatement) {
            this.startVisitScopeNode((ASTNode)forStatement);
            return true;
        }

        public boolean visit(IfStatement ifStatement) {
            return true;
        }

        public boolean visit(SwitchStatement switchStatement) {
            return true;
        }

        public boolean visit(TryStatement tryStatement) {
            return true;
        }

        public boolean visit(WhileStatement whileStatement) {
            return true;
        }

        public boolean visit(Include include) {
            Expression expr = include.getExpression();
            if (expr != null && (expr instanceof ParenthesisExpression || expr instanceof Scalar)) {
                Expression subExpr = null;
                subExpr = expr instanceof Scalar ? expr : ((ParenthesisExpression)expr).getExpression();
                if (subExpr == null) {
                    return true;
                }
                if (subExpr instanceof Scalar) {
                    ISourceModule module2;
                    String includePath = ((Scalar)subExpr).getStringValue();
                    if (includePath == null || includePath.length() == 0) {
                        return true;
                    }
                    subExpr.getStart();
                    if (includePath.startsWith("\"") || includePath.startsWith("'")) {
                        includePath = includePath.substring(1);
                    }
                    if (includePath.endsWith("\"") || includePath.endsWith("'")) {
                        includePath = includePath.substring(0, includePath.length() - 1);
                    }
                    if (this.module != null && (module2 = ((SourceModule)this.module).getModule(includePath)) != null) {
                        this.reporter.report((ASTNode)include, (IBinding)new ModuleBinding(module2));
                    }
                }
            }
            return true;
        }

        public void endVisit(Block block) {
            this.endVisitScopeNode((ASTNode)block);
        }

        public void endVisit(CatchClause catchClause) {
        }

        public void endVisit(DoStatement doStatement) {
        }

        public void endVisit(ForEachStatement forEachStatement) {
        }

        public void endVisit(ForStatement forStatement) {
            this.endVisitScopeNode((ASTNode)forStatement);
        }

        public void endVisit(IfStatement ifStatement) {
        }

        public void endVisit(SwitchStatement switchStatement) {
        }

        public void endVisit(TryStatement tryStatement) {
        }

        public void endVisit(WhileStatement whileStatement) {
        }

        private boolean handleAssigment(Variable variable, Assignment assigment, boolean staticDeclaration) {
            Expression value = assigment.getRightHandSide();
            String variableName = this.getVariableName((Expression)variable);
            if (variableName == null) {
                return true;
            }
            Set<Object> rightSideTypes = this.countExpressionTypes(value);
            VariableInfo variableInfo = new VariableInfo(variableName, rightSideTypes, this.getCurrentScope(), variable.getStart(), staticDeclaration ? 128 : 0);
            this.getCurrentScope().addVariable(variableInfo);
            return true;
        }

        String getVariableEntryPath(Variable variable) {
            String varName;
            String entryPath = "";
            if (this.currentFunction != null) {
                entryPath = String.valueOf(this.currentFunction.getEntryPath()) + '/';
            }
            if ((varName = this.getVariableName((Expression)variable)) == null) {
                return null;
            }
            entryPath = String.valueOf(entryPath) + varName;
            return entryPath;
        }

        private String getVariableName(Expression variable) {
            if (variable != null) {
                if (variable.getType() == 60) {
                    variable = ((Variable)variable).getName();
                }
                if (variable.getType() == 65 || variable.getType() == 33) {
                    return ((Identifier)variable).getName();
                }
            }
            return null;
        }

        private void startVisitScopeNode(ASTNode node) {
            Scope parent = null;
            if (!this.scopes.isEmpty()) {
                parent = this.scopes.peek();
            }
            IElementEntry currentEntry = null;
            if (node instanceof FunctionDeclaration) {
                currentEntry = this.currentFunction;
            }
            Scope scope = new Scope(node, parent, currentEntry);
            if (this.localParametersMap != null) {
                for (String s : this.localParametersMap.keySet()) {
                    scope.addVariable(new VariableInfo(s, this.localParametersMap.get(s), scope, 0));
                }
            }
            this.scopes.push(scope);
        }

        private void endVisitScopeNode(ASTNode node) {
            if (!this.scopes.isEmpty()) {
                if (!TypeBindingBuilder.this.globalMode && !this.localStackReported && node.getEnd() > TypeBindingBuilder.this.currentOffset) {
                    this.reportStack(this.scopes);
                    this.localStackReported = true;
                }
                Scope scope = this.scopes.pop();
                this.reportGlobalScopeVariables(scope);
            }
        }

        private Scope getCurrentScope() {
            return this.scopes.peek();
        }

        private Scope getGlobalScope() {
            return (Scope)this.scopes.get(0);
        }

        private void reportGlobalScopeVariables(Scope scope) {
        }

        private Set<Object> countVariableTypes(String variableName, Scope currentScope) {
            Set<Object> types;
            FunctionPHPEntryValue entryValue;
            Map<String, Set<Object>> parameters;
            IElementEntry entry;
            HashSet<Object> result = new HashSet<Object>();
            VariableInfo variable = currentScope.getVariable(variableName);
            if (variable != null) {
                result.addAll(variable.getVariableTypes());
            }
            if ((entry = this.findFunctionOrMethodParent(currentScope)) != null && (parameters = (entryValue = (FunctionPHPEntryValue)entry.getValue()).getParameters()) != null && (types = parameters.get(variableName)) != null) {
                result.addAll(types);
            }
            return result;
        }

        private IElementEntry findFunctionOrMethodParent(Scope scope) {
            Scope currentScope = scope;
            while (currentScope != null) {
                IElementEntry entry = currentScope.getEntry();
                if (entry != null && entry.getValue() instanceof FunctionPHPEntryValue) {
                    return entry;
                }
                currentScope = currentScope.getParent();
            }
            return null;
        }

        private Set<Object> countInfixExpressionTypes(InfixExpression expr) {
            int operator = expr.getOperator();
            String type = null;
            switch (operator) {
                case 16: {
                    type = "_string";
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    type = "_boolean";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    type = "_string";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    type = "_real";
                    break;
                }
                case 22: 
                case 23: {
                    type = "_integer";
                }
            }
            HashSet<Object> result = new HashSet<Object>(1);
            result.add(type);
            return result;
        }

        private CallPath getPathByStaticDispatch(StaticDispatch dispatch) {
            CallPath result = new CallPath();
            Expression classNameIdentifier = dispatch.getClassName();
            String className = null;
            if (classNameIdentifier == null || classNameIdentifier.getType() != 33 && classNameIdentifier.getType() != 65) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Expected an identifier or namespace-name", (Throwable)new Exception("Missing identifier"));
                return null;
            }
            className = ((Identifier)classNameIdentifier).getName();
            result.setClassEntry(className);
            ASTNode member = dispatch.getMember();
            String memberName = null;
            boolean field = true;
            if (member instanceof Variable) {
                Variable currentField = (Variable)member;
                memberName = this.getVariableName((Expression)currentField);
                if (memberName == null) {
                    return null;
                }
                field = true;
            } else if (member instanceof FunctionInvocation) {
                FunctionInvocation funcInvocation = (FunctionInvocation)member;
                memberName = this.getFunctionNameByInvocation(funcInvocation);
                if (memberName == null) {
                    return null;
                }
                field = false;
            } else {
                return null;
            }
            if (field) {
                result.addVariableEntry(memberName);
            } else {
                result.addMethodEntry(memberName);
            }
            return result;
        }

        private CallPath getPathByDispatch(Dispatch dispatch) {
            CallPath result = new CallPath();
            Dispatch currentDispatch = dispatch;
            while (currentDispatch != null) {
                String dispatecherName;
                VariableBase currentDispatcher = currentDispatch.getDispatcher();
                String memberName = null;
                boolean field = true;
                VariableBase member = currentDispatch.getMember();
                if (member instanceof Variable) {
                    Variable currentField = (Variable)member;
                    memberName = this.getVariableName((Expression)currentField);
                    if (memberName == null) {
                        return null;
                    }
                    field = true;
                } else if (member instanceof FunctionInvocation) {
                    FunctionInvocation funcInvocation = (FunctionInvocation)member;
                    memberName = this.getFunctionNameByInvocation(funcInvocation);
                    if (memberName == null) {
                        return null;
                    }
                    field = false;
                } else {
                    return null;
                }
                if (field) {
                    result.insertVariableEntry(memberName);
                } else {
                    result.insertMethodEntry(memberName);
                }
                if (currentDispatcher instanceof Dispatch) {
                    currentDispatch = (Dispatch)currentDispatcher;
                    continue;
                }
                if (currentDispatcher instanceof StaticDispatch) {
                    CallPath staticDispatchCallPath = this.getPathByStaticDispatch((StaticDispatch)currentDispatcher);
                    if (staticDispatchCallPath == null) {
                        return null;
                    }
                    staticDispatchCallPath.addPath(result);
                    return staticDispatchCallPath;
                }
                if (currentDispatcher instanceof Variable) {
                    dispatecherName = this.getVariableName((Expression)((Variable)currentDispatcher));
                    if (dispatecherName == null) {
                        return null;
                    }
                    result.insertVariableEntry(dispatecherName);
                    break;
                }
                if (currentDispatcher instanceof FunctionInvocation) {
                    dispatecherName = this.getFunctionNameByInvocation((FunctionInvocation)currentDispatcher);
                    if (dispatecherName == null) {
                        return null;
                    }
                    result.insertMethodEntry(dispatecherName);
                    break;
                }
                return null;
            }
            return result;
        }

        private Set<Object> countExpressionTypes(Expression expression) {
            Set<Object> result = null;
            if (expression instanceof Scalar) {
                Scalar scalar = (Scalar)expression;
                result = this.countScalarTypes(scalar);
            } else if (expression instanceof Variable) {
                Variable rightSideVar = (Variable)expression;
                String rightSideVarName = this.getVariableName((Expression)rightSideVar);
                if (rightSideVarName == null) {
                    return null;
                }
                result = this.countVariableTypes(rightSideVarName, this.getCurrentScope());
            } else if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation creation = (ClassInstanceCreation)expression;
                result = this.countInstanceCreationTypes(creation);
            } else if (expression instanceof FieldAccess || expression instanceof MethodInvocation) {
                Dispatch dispatch = (Dispatch)expression;
                result = this.countDispatchTypes(dispatch);
            } else if (expression instanceof StaticDispatch) {
                StaticDispatch staticDispatch = (StaticDispatch)expression;
                result = this.countStaticDispatchTypes(staticDispatch);
            } else if (expression instanceof FunctionInvocation) {
                FunctionInvocation invocation = (FunctionInvocation)expression;
                result = this.countFunctionInvocationTypes(invocation);
            } else if (expression instanceof InfixExpression) {
                InfixExpression infix = (InfixExpression)expression;
                result = this.countInfixExpressionTypes(infix);
            }
            return result;
        }

        private Set<Object> countFunctionInvocationTypes(FunctionInvocation invocation) {
            String functionName = this.getFunctionNameByInvocation(invocation);
            if (functionName == null) {
                return null;
            }
            FunctionPathReference reference = new FunctionPathReference(functionName, null);
            HashSet<Object> result = new HashSet<Object>(1);
            result.add(reference);
            return result;
        }

        private Set<Object> countScalarTypes(Scalar scalar) {
            int intType = scalar.getScalarType();
            String type = TypeBindingBuilder.typeToString(intType);
            HashSet<Object> result = new HashSet<Object>(1);
            result.add(type);
            return result;
        }

        private Set<Object> countInstanceCreationTypes(ClassInstanceCreation creation) {
            ClassName className = creation.getClassName();
            if (className == null) {
                return null;
            }
            Expression classNameExpr = className.getName();
            String clName = null;
            if (classNameExpr != null && (classNameExpr.getType() == 65 || classNameExpr.getType() == 33)) {
                clName = ((Identifier)classNameExpr).getName();
            }
            if (clName == null) {
                return null;
            }
            HashSet<Object> result = new HashSet<Object>(1);
            if (TypeBindingBuilder.SELF.equals(clName)) {
                if (this.currentClass != null) {
                    return result;
                }
                return null;
            }
            result.add(clName);
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Set<Object> countStaticDispatchTypes(StaticDispatch dispatch) {
            HashSet<Object> result = null;
            CallPath path = this.getPathByStaticDispatch(dispatch);
            if (path == null) return null;
            if (path.getSize() < 2) {
                return null;
            }
            CallPath remainingPath = path.subPath(1);
            List<CallPath.Entry> pathEntries = path.getEntries();
            CallPath.Entry dispatchEntry = pathEntries.get(0);
            if (dispatchEntry instanceof CallPath.ClassEntry && TypeBindingBuilder.SELF.equals(dispatchEntry.getName())) {
                if (this.currentClass == null) return null;
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                StaticPathReference reference = new StaticPathReference(dispatcherTypes, remainingPath);
                result = new HashSet<Object>(1);
                result.add(reference);
                return result;
            } else {
                if (!(dispatchEntry instanceof CallPath.ClassEntry)) return null;
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                dispatcherTypes.add(dispatchEntry.getName());
                StaticPathReference reference = new StaticPathReference(dispatcherTypes, remainingPath);
                result = new HashSet(1);
                result.add(reference);
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Set<Object> countDispatchTypes(Dispatch dispatch) {
            HashSet<Object> result = null;
            CallPath path = this.getPathByDispatch(dispatch);
            if (path == null) return null;
            if (path.getSize() < 2) {
                return null;
            }
            CallPath remainingPath = path.subPath(1);
            List<CallPath.Entry> pathEntries = path.getEntries();
            CallPath.Entry dispatchEntry = pathEntries.get(0);
            if (dispatchEntry instanceof CallPath.VariableEntry && TypeBindingBuilder.THIS.equals(dispatchEntry.getName())) {
                if (this.currentClass == null) return null;
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                VariablePathReference reference = new VariablePathReference(dispatcherTypes, remainingPath);
                result = new HashSet<Object>(1);
                result.add(reference);
                return result;
            } else if (dispatchEntry instanceof CallPath.ClassEntry && TypeBindingBuilder.SELF.equals(dispatchEntry.getName())) {
                if (this.currentClass == null) return null;
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                StaticPathReference reference = new StaticPathReference(dispatcherTypes, remainingPath);
                result = new HashSet(1);
                result.add(reference);
                return result;
            } else if (dispatchEntry instanceof CallPath.ClassEntry) {
                HashSet<Object> dispatcherTypes = new HashSet<Object>(1);
                dispatcherTypes.add(dispatchEntry.getName());
                StaticPathReference reference = new StaticPathReference(dispatcherTypes, remainingPath);
                result = new HashSet(1);
                result.add(reference);
                return result;
            } else if (dispatchEntry instanceof CallPath.VariableEntry) {
                Set<Object> dispatcherTypes = this.countVariableTypes(dispatchEntry.getName(), this.getCurrentScope());
                if (dispatcherTypes == null) {
                    return null;
                }
                VariablePathReference reference = new VariablePathReference(dispatcherTypes, remainingPath);
                result = new HashSet(1);
                result.add(reference);
                return result;
            } else {
                if (!(dispatchEntry instanceof CallPath.MethodEntry)) return null;
                String methodEntryPath = ((CallPath.MethodEntry)dispatchEntry).getName();
                FunctionPathReference reference = new FunctionPathReference(methodEntryPath, remainingPath);
                result = new HashSet(1);
                result.add(reference);
            }
            return result;
        }

        private String getFunctionNameByInvocation(FunctionInvocation invocation) {
            FunctionName funcName = invocation.getFunctionName();
            if (funcName == null) {
                return null;
            }
            Expression funcNameExpression = funcName.getName();
            return this.getVariableName(funcNameExpression);
        }

        private void reportStack(List<Scope> stack) {
            if (stack.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < stack.size()) {
                Scope currentScope = stack.get(i);
                Set<String> currentGlobalImports = currentScope.getGlobalImports();
                if (currentGlobalImports != null) {
                    TypeBindingBuilder.this.overallGlobalImports.addAll(currentGlobalImports);
                }
                ++i;
            }
            Scope currentScope = null;
            int i2 = stack.size() - 1;
            while (i2 >= 0) {
                currentScope = stack.get(i2);
                ASTNode root = currentScope.getRoot();
                if (root != null && root.getStart() < TypeBindingBuilder.this.currentOffset) break;
                --i2;
            }
            if (currentScope == null) {
                return;
            }
            TypeBindingBuilder.this.isReportedStackGlobal = currentScope.isGlobalScope();
            Set<VariableInfo> variables = currentScope.getVariables();
            for (VariableInfo varInfo : variables) {
                if (varInfo.getNodeStart() <= TypeBindingBuilder.this.currentOffset) continue;
            }
        }

        String getScopePath(List<Scope> stack, int pos) {
            StringBuffer result = new StringBuffer();
            int i = pos;
            while (i >= 0) {
                String className;
                Identifier classNameIdentifier;
                String functionName;
                Identifier funcNameIdentifier;
                Scope currentScope = stack.get(i);
                ASTNode root = currentScope.getRoot();
                if (root instanceof FunctionDeclaration) {
                    funcNameIdentifier = ((FunctionDeclaration)root).getFunctionName();
                    if (funcNameIdentifier != null && (functionName = funcNameIdentifier.getName()) != null) {
                        result.insert(0, String.valueOf(functionName) + '/');
                    }
                } else if (root instanceof MethodDeclaration) {
                    funcNameIdentifier = ((MethodDeclaration)root).getFunction().getFunctionName();
                    if (funcNameIdentifier != null && (functionName = funcNameIdentifier.getName()) != null) {
                        result.insert(0, String.valueOf(functionName) + '/');
                    }
                } else if (root instanceof ClassDeclaration && (classNameIdentifier = ((ClassDeclaration)root).getName()) != null && (className = classNameIdentifier.getName()) != null) {
                    result.insert(0, String.valueOf(className) + '/');
                }
                --i;
            }
            return result.toString();
        }

        private String[] applyFunctionComment(Comment comment, Map<String, Set<Object>> parametersMap) {
            TypedDescription returnDescr;
            block12: {
                FunctionDocumentation doc;
                block11: {
                    doc = PHPDocUtils.getFunctionDocumentation((IPHPDoc)comment);
                    if (doc != null) break block11;
                    return null;
                }
                try {
                    TypedDescription[] params = doc.getParams();
                    if (params != null && params.length != 0) {
                        TypedDescription[] typedDescriptionArray = params;
                        int n = params.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TypedDescription param = typedDescriptionArray[n2];
                            String paramName = param.getName();
                            if (paramName != null && paramName.length() != 0) {
                                Set toSetParams;
                                if (paramName.startsWith("$")) {
                                    paramName = paramName.substring(1);
                                }
                                String[] types = param.getTypes();
                                Set<Object> set = toSetParams = parametersMap != null ? parametersMap.get(paramName) : Collections.emptySet();
                                if (toSetParams == null) {
                                    toSetParams = new HashSet();
                                    parametersMap.put(paramName, toSetParams);
                                }
                                if (types != null) {
                                    String[] stringArray = types;
                                    int n3 = types.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        String type = stringArray[n4];
                                        toSetParams.add(type);
                                        ++n4;
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    if ((returnDescr = doc.getReturn()) != null) break block12;
                    return null;
                }
                catch (Throwable th) {
                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP Type-Binding builder - Error while applying a comment to a parameter type (applyComment)", (Throwable)th, (String)"com.aptana.editor.php/debug");
                    return null;
                }
            }
            return returnDescr.getTypes();
        }

        private IElementEntry reportField(int modifier, String fieldName, Set<Object> fieldTypes, int pos) {
            return null;
        }

        private void addBlockVariables(Block block) {
            ASTNode blockParent = block.getParent();
            if (blockParent instanceof CatchClause) {
                this.addCatchClauseVariables((CatchClause)blockParent);
            } else if (blockParent instanceof ForStatement) {
                this.addForVariables((ForStatement)blockParent);
            } else if (blockParent instanceof ForEachStatement) {
                this.addForEachVariables((ForEachStatement)blockParent);
            }
        }

        private void addForEachVariables(ForEachStatement foreachStatement) {
            VariableInfo info;
            String varName;
            Expression key = foreachStatement.getKey();
            Expression value = foreachStatement.getValue();
            if (key != null && key instanceof Variable && (varName = this.getVariableName((Expression)((Variable)key))) != null) {
                info = new VariableInfo(varName, null, this.getCurrentScope(), key.getStart());
                this.getCurrentScope().addVariable(info);
            }
            if (value != null && value instanceof Variable && (varName = this.getVariableName((Expression)((Variable)value))) != null) {
                info = new VariableInfo(varName, null, this.getCurrentScope(), value.getStart());
                this.getCurrentScope().addVariable(info);
            }
        }

        private void addForVariables(ForStatement forStatement) {
            List initializations = forStatement.initializers();
            if (initializations == null || initializations.size() == 0) {
                return;
            }
            for (Expression initialization : initializations) {
                Set<Object> types;
                String varName;
                Assignment assigment;
                VariableBase var;
                if (!(initialization instanceof Assignment) || !((var = (assigment = (Assignment)initialization).getLeftHandSide()) instanceof Variable) || (varName = this.getVariableName((Expression)((Variable)var))) == null || (types = this.countExpressionTypes(assigment.getRightHandSide())) == null || types.size() == 0) continue;
                VariableInfo info = new VariableInfo(varName, types, this.getCurrentScope(), var.getStart());
                this.getCurrentScope().addVariable(info);
            }
        }

        private void addCatchClauseVariables(CatchClause clause) {
            Variable var = clause.getVariable();
            String varName = this.getVariableName((Expression)var);
            if (varName != null) {
                VariableInfo info = new VariableInfo(varName, "Exception", this.getCurrentScope(), var.getStart());
                this.getCurrentScope().addVariable(info);
            }
        }
    }

    private static class Scope {
        private ASTNode root;
        private IElementEntry entry;
        private Map<String, VariableInfo> variables;
        private Scope parent;
        private Set<String> globalImports = new HashSet<String>();

        private Scope(ASTNode root, Scope parent) {
            this.root = root;
            this.parent = parent;
            this.entry = null;
            this.variables = new HashMap<String, VariableInfo>(1);
        }

        private Scope(ASTNode root, Scope parent, IElementEntry entry) {
            this.root = root;
            this.parent = parent;
            this.entry = entry;
            this.variables = new HashMap<String, VariableInfo>(1);
        }

        public Set<String> getGlobalImports() {
            return this.globalImports;
        }

        public void addGlobalImports(Set<String> imports) {
            this.globalImports.addAll(imports);
        }

        public void addGlobalImport(String importVariable) {
            this.globalImports.add(importVariable);
        }

        public boolean isGlobalScope() {
            return this.root instanceof Program;
        }

        public void addVariable(VariableInfo variable) {
            VariableInfo existingVariable = this.getVariable(variable.getName());
            if (existingVariable != null) {
                if (variable.getVariableTypes() != null && !variable.getVariableTypes().isEmpty()) {
                    if (this.equals(existingVariable.getScope())) {
                        existingVariable.setVariableTypes(variable.getVariableTypes());
                    } else {
                        for (Object type : variable.getVariableTypes()) {
                            existingVariable.addVariableType(type);
                        }
                    }
                }
            } else {
                this.variables.put(variable.getName(), variable);
            }
        }

        public VariableInfo getVariable(String name) {
            return this.getVariable(name, new HashSet<String>());
        }

        public VariableInfo getVariable(String name, Set<String> importsFromGlobal) {
            VariableInfo info;
            if (this.globalImports != null && !this.globalImports.isEmpty()) {
                importsFromGlobal.addAll(this.globalImports);
            }
            if ((info = this.variables.get(name)) != null) {
                return info;
            }
            if (this.parent != null) {
                if (this.parent.isGlobalScope()) {
                    if (importsFromGlobal.contains(name) || !(this.root instanceof FunctionDeclaration) && !(this.root instanceof ClassDeclaration)) {
                        return this.parent.getVariable(name, importsFromGlobal);
                    }
                } else {
                    return this.parent.getVariable(name, importsFromGlobal);
                }
            }
            return null;
        }

        public IElementEntry getEntry() {
            return this.entry;
        }

        public ASTNode getRoot() {
            return this.root;
        }

        public Scope getParent() {
            return this.parent;
        }

        public Set<VariableInfo> getVariables() {
            return this.getVariables(new HashSet<String>());
        }

        private Set<VariableInfo> getVariables(Set<String> importsFromGlobal) {
            if (this.globalImports != null && !this.globalImports.isEmpty()) {
                importsFromGlobal.addAll(this.globalImports);
            }
            HashSet<VariableInfo> result = new HashSet<VariableInfo>();
            for (VariableInfo variable : this.variables.values()) {
                result.add(variable);
            }
            if (this.parent != null) {
                if (!this.parent.isGlobalScope()) {
                    result.addAll(this.parent.getVariables(importsFromGlobal));
                } else if (this.automaticallyDeriveGlobalVariables()) {
                    result.addAll(this.parent.getVariables(new HashSet<String>()));
                } else {
                    for (String var : importsFromGlobal) {
                        VariableInfo varInfo = this.parent.getVariable(var, importsFromGlobal);
                        if (varInfo == null) continue;
                        result.add(varInfo);
                    }
                }
            }
            return result;
        }

        private boolean automaticallyDeriveGlobalVariables() {
            if (!this.parent.isGlobalScope()) {
                return false;
            }
            return !(this.getRoot() instanceof TypeDeclaration) && !(this.getRoot() instanceof FunctionDeclaration) && !(this.getRoot() instanceof MethodDeclaration);
        }
    }

    private static class VariableInfo {
        private String variableName;
        private Set<Object> variableTypes;
        private Scope scope;
        private int nodeStart = 0;
        private int modifier = 0;

        private VariableInfo(String variableName, Object variableType, Scope scope, int pos) {
            this.variableName = variableName;
            this.variableTypes = new HashSet<Object>(1);
            if (variableType != null) {
                this.variableTypes.add(variableType);
            }
            this.scope = scope;
            this.nodeStart = pos;
        }

        private VariableInfo(String variableName, Set<Object> variableTypes, Scope scope, int pos) {
            this.variableName = variableName;
            this.variableTypes = variableTypes;
            this.scope = scope;
            this.nodeStart = pos;
        }

        private VariableInfo(String variableName, Set<Object> variableTypes, Scope scope, int pos, int modifier) {
            this.variableName = variableName;
            this.variableTypes = variableTypes;
            this.scope = scope;
            this.nodeStart = pos;
            this.modifier = modifier;
        }

        public Set<Object> getVariableTypes() {
            if (this.variableTypes != null) {
                return this.variableTypes;
            }
            return Collections.emptySet();
        }

        public void setVariableType(Object variableType) {
            this.variableTypes = new HashSet<Object>(1);
            this.variableTypes.add(variableType);
        }

        public void setVariableTypes(Collection<Object> variableType) {
            this.variableTypes = new HashSet<Object>();
            this.variableTypes.addAll(variableType);
        }

        public void addVariableType(Object variableType) {
            if (this.variableTypes == null) {
                this.variableTypes = new HashSet<Object>();
            }
            this.variableTypes.add(variableType);
        }

        public String getName() {
            return this.variableName;
        }

        public Scope getScope() {
            return this.scope;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.variableName);
            buffer.append(" types:");
            buffer.append(this.variableTypes.toString());
            return buffer.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.variableName == null ? 0 : this.variableName.hashCode());
            return result;
        }

        public int getNodeStart() {
            return this.nodeStart;
        }

        public int getModifier() {
            return this.modifier;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableInfo other = (VariableInfo)obj;
            return !(this.variableName == null ? other.variableName != null : !this.variableName.equals(other.variableName));
        }
    }
}

